#include "stdafx.h"
#include "windows.h"

void ZmodyfikujKod(void *addr, int rozmiarKodu, char *ciekaKlucza) 
{ 
	byte * bufor = new byte[rozmiarKodu];
	FILE * plik;
	fopen_s(&plik, ciekaKlucza,  "rb");
	int przeczytano = fread(bufor, sizeof(byte), rozmiarKodu, plik);
	if(przeczytano == rozmiarKodu)  // zauwa, e nie reagujemy na bd odczytu - program wykona si jakby by nadal zabezpieczony
	{
		HANDLE h = OpenProcess(PROCESS_VM_OPERATION|PROCESS_VM_WRITE, true, GetCurrentProcessId()); 
		WriteProcessMemory(h, addr, bufor, rozmiarKodu, NULL); 
		CloseHandle(h);		
	}
	fclose(plik);
	delete bufor;
} 

void PobierzKod(void *addr, int rozmiarKodu) 
{
	byte * bufor = new byte[rozmiarKodu];
	SIZE_T przeczytano = 0;

	HANDLE h = OpenProcess(PROCESS_VM_OPERATION|PROCESS_VM_READ, true, GetCurrentProcessId()); 
	ReadProcessMemory(h, addr, (void*)bufor, rozmiarKodu, &przeczytano);
	CloseHandle(h);

	if(przeczytano != rozmiarKodu)
		printf("Nie udao si wykona zrzutu");
	else
	{
		FILE *plik;
		fopen_s(&plik, "klucz.dat",  "wb");
		fwrite(bufor, sizeof(byte), przeczytano, plik);
		fclose(plik);
	}

	delete bufor;
}

// Funkcja ktr zabezpieczamy. Moe pracowa w trzech trybach
// 0 - tryb normalny
// 1 - tryb zabezpieczania
// 2 - tryb odbezpieczania przy pomocy pliku z kluczem
// Uzycie trybu zabezpieczania powoduje zrzut chronionego adresu do pliku klucz.dat
// Tryb odbezpieczania na odwrt: pobiera z key.dat dane, modyfikuje kod 
// We wszystkich trybach waciwy kod funkcji jest uruchamiany
int Funkcja(int tryb = 0, char * ciekaKlucza = NULL)
{
	if(tryb == 2) 
	{
		_asm
		{
			push ciekaKlucza					// cieka do pliku z kluczem
			push 0x30;							// rozmiar zabezpeiczanego kodu
			push offset ZabezpieczanyKod		// adres zabezpieczanego kodu
			call ZmodyfikujKod
			add esp, 12 
		}
	}
	else if(tryb == 1)
	{
		_asm
		{
			push 0x30;							// rozmiar zabezpeiczanego kodu
			push offset ZabezpieczanyKod		// adres zabezpieczanego kodu
			call PobierzKod
			add esp, 8 
		}
	}
ZabezpieczanyKod:
	// Przed zabezpieczeniem w tym miejscu znajduje si poniszy kod. Po zabezpieczeniu programu jest on zamieniany na instrukcje NOP
	// Tak te wyglda on jeli w debugerze zatrzymasz wykonanie na pocztku funkcji
	// Jednak gdy zatrzymasz wywoanie w tym miejscu, to zobaczysz ju prawidowy kod
	int wynik = 1;
	for(int i = 0; i < 10; i++)
		wynik += wynik * 2;
	return wynik;	
	// Jeli chcesz jeszcze utrudni zamanie programu, to moesz w tym miejscu ponownie wypenia powyszy fragment kodu zerami
}

int main(int argc, char* argv[])
{
	// jeli program uruchomiony jest w trybie zabezpieczania z tajnym hasem, zrzuci do pliku output.dat zawarto funkcji Funkcja do zabepieczenia
	if(argc > 1 && !strcmp (argv[1], "tajnehaslo"))
		printf("wynik %d, wygenerowano zrzut do pliku klucz.dat", Funkcja(1)); 
	// jeli parametrem nie jest tajne haso, to zakadam, e bdzie to plik z kluczem
	else if(argc > 1)
	// w przeciwnym razie wykonujemy program bez zmian, jeli go zabezpieczylimy, to wykona si nieprawidowo
		printf("wynik %d", Funkcja(2, argv[1])); 
	else
		printf("wynik %d", Funkcja(0)); 
    return 0; 
}



